#ifdef GL_ES
precision mediump float;

varying vec3 normal;
varying vec2 vTexCoord;

vec4 fragColor;
#else
in vec3 normal;
in vec2 vTexCoord;

out vec4 fragColor;
#endif
uniform sampler2D colorTex;
uniform vec3 ambient;
uniform vec3 specularColor;
uniform float shininess;

uniform vec3 lightSource0;
uniform vec3 lightSource0HV;

void main()
{
#ifdef GL_ES
    vec4 tColor = texture2D(colorTex, vTexCoord.st);
#else
    vec4 tColor = texture(colorTex, vTexCoord.st);
#endif
    vec3 norm = normalize(normal);

    float lambert = dot(norm, lightSource0);
    float specFactor = dot(norm, lightSource0HV);
    float specular = pow(specFactor, shininess);

    vec3 diffuse = lambert * tColor.rgb;
    vec3 newSpec = (specular * tColor.a) * specularColor;

    fragColor = vec4(diffuse + newSpec + ambient, 1.0);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
